const jwt = require("jsonwebtoken");

function verifyAuthToken(req, res, next) {
  //get token from header
  const token = req.header("Authorization")?.split(" ")[1];

  //check if not token
  if (!token) {
    return res.status(401).json({ msg: "No token, Authorization denied" });
  }

  //Verify Token
  try {
    let decoded = jwt.verify(token, process.env.SECRET_KEY);
    if (decoded) {
      req.user = { ...decoded };
      next();
    } else {
      return res.status(401).json({ msg: "Authorization Failed" });
    }
  } catch (err) {
    return res.status(401).json({ msg: "Token is invalid" });
  }
}

function checkAdmin(req, res, next) {
  if (req.user?.role === "admin") {
    next();
  } else {
    return res.status(403).json({ msg: "Authorization failed" });
  }
}

module.exports = { verifyAuthToken, checkAdmin };
