const jwt = require("jsonwebtoken");

function verifyBasicToken(req, res, next) {
  //get token from header
  const token = req.header("Basic-Token");

  //check if not token
  if (!token) {
    return res.status(401).json({ msg: "No token, Authorization denied" });
  }

  //Verify Token
  try {
    if (token === process.env.BASIC_TOKEN) {
      next();
    } else {
      return res.status(401).json({ msg: "Authorization Failed" });
    }
  } catch (err) {
    return res.status(401).json({ msg: "Token is invalid" });
  }
}

module.exports = verifyBasicToken;
