"use strict";
module.exports = {
  async up(queryInterface, Sequelize) {
    await queryInterface.createTable("tales", {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: Sequelize.INTEGER,
      },
      video_url: {
        type: Sequelize.TEXT,
      },
      name: {
        type: Sequelize.STRING,
      },
      keywords: {
        type: Sequelize.TEXT,
      },
      type: {
        type: Sequelize.STRING,
      },
      user: {
        type: Sequelize.STRING,
      },
      address: {
        type: Sequelize.INTEGER,
      },
      published_at: {
        type: Sequelize.DATE,
      },
      is_moment: {
        type: Sequelize.BOOLEAN,
      },
      tales_id: {
        type: Sequelize.INTEGER,
      },
      category_id: {
        type: Sequelize.INTEGER,
      },
      description: {
        type: Sequelize.TEXT,
      },
      start_time: { type: Sequelize.FLOAT, defaultValue: 0.0 },
      end_time: { type: Sequelize.FLOAT, defaultValue: 0.0 },
      video_type: { type: Sequelize.STRING, allowNull: false },
      thumbnail: Sequelize.TEXT,

      createdAt: {
        allowNull: false,
        type: Sequelize.DATE,
      },
      updatedAt: {
        allowNull: false,
        type: Sequelize.DATE,
      },
    });
  },
  async down(queryInterface, Sequelize) {
    await queryInterface.dropTable("tales");
  },
};
