"use strict";
const { Model } = require("sequelize");
module.exports = (sequelize, DataTypes) => {
  class address extends Model {
    /**
     * Helper method for defining associations.
     * This method is not a part of Sequelize lifecycle.
     * The `models/index` file will call this method automatically.
     */
    static associate(models) {
      // define association here
    }
  }
  address.init(
    {
      country: { type: DataTypes.STRING, allowNull: false },
      iso_code: { type: DataTypes.STRING, allowNull: false },
      state: DataTypes.STRING,
      street1: DataTypes.STRING,
      street2: DataTypes.STRING,
      zip: { type: DataTypes.INTEGER, allowNull: true },
      lat: { type: DataTypes.FLOAT, allowNull: true },
      long: { type: DataTypes.FLOAT, allowNull: true },
    },
    {
      sequelize,
      modelName: "address",
    }
  );
  return address;
};
