"use strict";
const { Model } = require("sequelize");
module.exports = (sequelize, DataTypes) => {
  class tales extends Model {
    /**
     * Helper method for defining associations.
     * This method is not a part of Sequelize lifecycle.
     * The `models/index` file will call this method automatically.
     */
    static associate(models) {
      // define association here
      tales.belongsTo(models.address, {
        foreignKey: "address",
        as: "tale_address",
      });

      tales.hasMany(models.tales, {
        foreignKey: "tales_id",
        as: "children_tales",
      });
    }
  }
  tales.init(
    {
      video_url: { type: DataTypes.TEXT, allowNull: false },
      name: { type: DataTypes.STRING, allowNull: false },
      keywords: DataTypes.TEXT,
      type: DataTypes.STRING,
      user: DataTypes.STRING,
      address: DataTypes.INTEGER,
      published_at: DataTypes.DATE,
      is_moment: DataTypes.BOOLEAN,
      tales_id: DataTypes.INTEGER,
      category_id: DataTypes.INTEGER,
      description: DataTypes.TEXT,
      start_time: { type: DataTypes.FLOAT, defaultValue: 0.0 },
      end_time: { type: DataTypes.FLOAT, defaultValue: 0.0 },
      video_type: { type: DataTypes.STRING, allowNull: false },
      thumbnail: DataTypes.TEXT,
    },
    {
      sequelize,
      modelName: "tales",
    }
  );
  return tales;
};
