"use strict";
const { Model } = require("sequelize");
module.exports = (sequelize, DataTypes) => {
  class Users extends Model {
    /**
     * Helper method for defining associations.
     * This method is not a part of Sequelize lifecycle.
     * The `models/index` file will call this method automatically.
     */
    static associate(models) {
      // define association here
    }
  }
  Users.init(
    {
      fullName: { type: DataTypes.STRING, allowNull: false },
      gender: {
        type: DataTypes.ENUM("Male", "Female", "Others"),
        defaultValue: "Male",
      },
      email: { type: DataTypes.STRING, unique: true },
      phone: { type: DataTypes.STRING, unique: true },
      country_code: { type: DataTypes.STRING, unique: false },
      country_iso: { type: DataTypes.STRING, unique: false },

      username: { type: DataTypes.STRING, allowNull: false, unique: true },
      password: { type: DataTypes.STRING, allowNull: false },
      role: { type: DataTypes.ENUM("admin", "user"), defaultValue: "user" },
      otp: DataTypes.INTEGER,
      is_verified: {
        type: DataTypes.BOOLEAN,
        defaultValue: false,
      },
    },
    {
      sequelize,
      modelName: "Users",
    }
  );
  return Users;
};
