"use strict";
const { Model } = require("sequelize");
module.exports = (sequelize, DataTypes) => {
  class UserSessions extends Model {
    /**
     * Helper method for defining associations.
     * This method is not a part of Sequelize lifecycle.
     * The `models/index` file will call this method automatically.
     */
    static associate(models) {
      // define association here
    }
  }
  UserSessions.init(
    {
      user_id: DataTypes.INTEGER,
      device_id: DataTypes.STRING,
      device_type: { type: DataTypes.ENUM("web", "android", "ios") },
      fcm_token: DataTypes.STRING,
      ip_address: DataTypes.STRING,
      access_token: DataTypes.TEXT,
      refresh_token: DataTypes.TEXT,
    },
    {
      sequelize,
      modelName: "UserSessions",
    }
  );
  return UserSessions;
};
