const express = require("express");
const {
  CreateTales,
  SaveTales,
  GetTales,
  PublishTales,
} = require("../controller/TalesController");
const { verifyAuthToken } = require("../middleware/AuthMiddleware");

const TaleRouter = express.Router();

TaleRouter.post("/create", verifyAuthToken, CreateTales);

TaleRouter.post("/save", verifyAuthToken, SaveTales);
TaleRouter.get("/get", GetTales);
TaleRouter.put("/publish/:tale_id", verifyAuthToken, PublishTales);

module.exports = TaleRouter;
