const express = require("express");
const {
  RegisterUser,
  LoginUser,
  VerifyToken,
  ForgotPassword,
  VerifyForgotOTP,
  ChangePassword,
  RefreshToken,
} = require("../controller/UserController");

const UserRouter = express.Router();

UserRouter.post("/register", RegisterUser);
UserRouter.post("/login", LoginUser);
UserRouter.post("/verifyOtp", VerifyToken);
UserRouter.post("/forgotPassword", ForgotPassword);
UserRouter.post("/verifyForgotOTP", VerifyForgotOTP);
UserRouter.post("/changePassword", ChangePassword);
UserRouter.get("/refresh", RefreshToken);

module.exports = UserRouter;
