const express = require("express");
const dotenv = require("dotenv");
const UserRouter = require("./routes/UserRoutes");
const verifyBasicToken = require("./middleware/basicMiddleware");
const TaleRouter = require("./routes/TaleRoutes");

dotenv.config();

const app = express();
app.use(express.json());
app.use(verifyBasicToken);

app.set("trust proxy", true);

const PORT = process.env.PORT || 3000;

app.use("/api/v1/user", UserRouter);
app.use("/api/v1/tales", TaleRouter);

app.listen(PORT, () => {
  console.log(`Server running on port ${PORT}`);
});
