const models = require("../models");
const Address = models.address;

const createAddress = (addressData) => {
  return new Promise(async (resolve, reject) => {
    try {
      let newAddress = await Address.create({ ...addressData });
      return resolve(newAddress);
    } catch (e) {
      return reject(new Error(e.message));
    }
  });
};

module.exports = {
  createAddress,
};
