const Joi = require("joi");

const registerValidate = Joi.object({
  fullName: Joi.string().min(5).required(),
  username: Joi.string().min(5),
  gender: Joi.string().optional().valid("Male", "Female", "Others"),
  email: Joi.any().required(),
  phone: Joi.any().required(),
  country_code: Joi.any().required(),
  country_iso: Joi.any().required(),

  password: Joi.string().min(7).required().strict(),
  role: Joi.optional(),
});

const loginValidate = Joi.object({
  loginKey: Joi.string().required(),
  password: Joi.string().required(),
  device_type: Joi.string().required().valid("web", "android", "ios"),
  fcm_token: Joi.string().optional(),
  device_id: Joi.string().required(),
});

const verifyTokenValidate = Joi.object({
  loginKey: Joi.string().required(),
  otp: Joi.number().integer().min(1000).max(9999).required(),
});

const forgotPasswordValidate = Joi.object({
  emailOrPhone: Joi.string().required(),
});

const verifyForgotOTPValidate = Joi.object({
  emailOrPhone: Joi.string().required(),
  otp: Joi.number().integer().min(1000).max(9999).required(),
});

const changePasswordValidate = Joi.object({
  emailOrPhone: Joi.string().required(),
  otp: Joi.number().integer().min(1000).max(9999).required(),
  password: Joi.string().min(7).required().strict(),
});

module.exports = {
  registerValidate,
  loginValidate,
  verifyTokenValidate,
  forgotPasswordValidate,
  verifyForgotOTPValidate,
  changePasswordValidate,
};
